#ifndef __CONFIG_FILE_H__
#define __CONFIG_FILE_H__

#include <string>
#include <map>

class ConfigFile {
private:
	std::map<std::string, std::string> content_;
	bool fileFound;
	
public:
  ConfigFile(std::string configFile);

  bool FileWasLoaded(){ return fileFound; }

  std::string Value(std::string const& section, std::string const& entry, std::string const& default = "") const;
  int ConfigFile::Value(std::string const& section, std::string const& entry, int const default = 0) const;
  double ConfigFile::Value(std::string const& section, std::string const& entry, double const default = 0) const;
};

#endif